/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.rcs.sas;

import com.ibm.hwmca.fw.rcs.sas.SasUtil;
import com.ibm.hwmca.fw.util.Trace;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class ZSeriesEnrollment
implements Serializable {
    private static final String TRACE_MASKT = "XSASZSET";
    private static final String TRACE_MASKF = "XSASZSEF";
    private static final String TRACE_MASKD = "XSASZSED";
    private static final String ZSERIES_ENROLLMENT = "zseries-enrollment";
    private static final String CONTACT_NAME = "contact-name";
    private static final String CONTACT_DEPARTMENT = "contact-department";
    private static final String CONTACT_PHONE_NUMBER = "contact-phone-number";
    private static final String CONTACT_PHONE_EXTENSION = "contact-phone-extension";
    private static final String CONTACT_EMAIL = "contact-email";
    private static final String LOCALE = "locale";
    private static final String LAST_UPDATE_TIMESTAMP = "last-update_TIMESTAMP";
    public String contactName;
    public String contactDepartment;
    public String contactPhoneNumber;
    public String contactPhoneExtension;
    public String contactEmail;
    public Locale locale;
    public Date lastUpdateTimestamp;

    public ZSeriesEnrollment(String contactName, String contactPhoneNumber, String contactEmail, Date lastUpdateTimestamp) {
        this(contactName, null, contactPhoneNumber, null, contactEmail, null, lastUpdateTimestamp);
        Trace.trace(TRACE_MASKT, "<> ZSeriesEnrollment.ZSeriesEnrollment(contactName=" + contactName + ", " + "contactPhoneNumber=" + contactPhoneNumber + ", " + "contactEmail=" + contactEmail + ", " + "lastUpdateTimestamp=" + lastUpdateTimestamp + ")");
    }

    public ZSeriesEnrollment(String contactName, String contactDepartment, String contactPhoneNumber, String contactPhoneExtension, String contactEmail, Locale locale, Date lastUpdateTimestamp) {
        this.contactName = contactName;
        this.contactDepartment = contactDepartment;
        this.contactPhoneNumber = contactPhoneNumber;
        this.contactPhoneExtension = contactPhoneExtension;
        this.contactEmail = contactEmail;
        this.locale = locale;
        this.lastUpdateTimestamp = lastUpdateTimestamp;
        Trace.trace(TRACE_MASKT, "<> ZSeriesEnrollment.ZSeriesEnrollment(contactName=" + contactName + ", " + "contactDepartment=" + contactDepartment + ", " + "contactPhoneNumber=" + contactPhoneNumber + ", " + "contactPhoneExtension=" + contactPhoneExtension + ", " + "contactEmail=" + contactEmail + ", " + "locale=" + locale + ", " + "lastUpdateTimestamp=" + lastUpdateTimestamp + ")");
    }

    public String toXml() {
        Trace.trace(TRACE_MASKT, "-> ZSeriesEnrollment.toXml()");
        StringBuffer buffer = new StringBuffer();
        buffer.append("<");
        buffer.append(ZSERIES_ENROLLMENT);
        buffer.append(" ");
        buffer.append("contact-name=\"" + SasUtil.convert4Xml(this.contactName) + "\"");
        if (this.contactDepartment != null && this.contactDepartment.length() > 0) {
            buffer.append(" ");
            buffer.append("contact-department=\"" + SasUtil.convert4Xml(this.contactDepartment) + "\"");
        }
        buffer.append(" ");
        buffer.append("contact-phone-number=\"" + SasUtil.convert4Xml(this.contactPhoneNumber) + "\"");
        if (this.contactPhoneExtension != null && this.contactPhoneExtension.length() > 0) {
            buffer.append(" ");
            buffer.append("contact-phone-extension=\"" + SasUtil.convert4Xml(this.contactPhoneExtension) + "\"");
        }
        buffer.append(" ");
        buffer.append("contact-email=\"" + SasUtil.convert4Xml(this.contactEmail) + "\"");
        if (this.locale != null) {
            buffer.append(" ");
            buffer.append("locale=\"" + SasUtil.convert4Xml(this.locale.toString()) + "\"");
        } else {
            buffer.append(" ");
            buffer.append("locale=\"" + SasUtil.convert4Xml(Locale.getDefault().toString()) + "\"");
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT+0"));
        buffer.append(" ");
        buffer.append("last-update_TIMESTAMP=\"" + SasUtil.convert4Xml(dateFormat.format(this.lastUpdateTimestamp)) + "\"");
        buffer.append("/>");
        Trace.trace(TRACE_MASKT, "<- ZSeriesEnrollment.toXml()");
        return buffer.toString();
    }

    public Object clone() {
        Trace.trace(TRACE_MASKT, "-> ZSeriesEnrollment.clone()");
        Object object = null;
        try {
            object = super.clone();
        }
        catch (CloneNotSupportedException exc) {
            Trace.trace(TRACE_MASKF, exc);
        }
        Trace.trace(TRACE_MASKT, "<- ZSeriesEnrollment.clone()");
        return object;
    }

    public boolean equals(Object object) {
        Trace.trace(TRACE_MASKT, "-> ZSeriesEnrollment.equals(" + object + ")");
        boolean result = false;
        if (object != null && object instanceof ZSeriesEnrollment) {
            ZSeriesEnrollment zSeriesEnrollment = (ZSeriesEnrollment)object;
            if (this.contactName.equals(zSeriesEnrollment.contactName) && this.contactDepartment.equals(zSeriesEnrollment.contactDepartment) && this.contactPhoneNumber.equals(zSeriesEnrollment.contactPhoneNumber) && this.contactPhoneExtension.equals(zSeriesEnrollment.contactPhoneExtension) && this.contactEmail.equals(zSeriesEnrollment.contactEmail) && this.locale.equals(zSeriesEnrollment.locale) && this.lastUpdateTimestamp.equals(zSeriesEnrollment.lastUpdateTimestamp)) {
                result = true;
            }
        }
        Trace.trace(TRACE_MASKT, "<- ZSeriesEnrollment.equals()");
        return result;
    }
}

